---
allowed-tools: Read, Write, Edit, WebSearch
argument-hint: [decision-context] | --strategic | --investment | --operational | --crisis-response
description: Explore complex decision branches with probability analysis, expected value calculation, and optimization
---

# Decision Tree Explorer

Explore complex decision scenarios with comprehensive probability analysis and optimization: **$ARGUMENTS**

## Current Decision Context

- Decision scope: Based on $ARGUMENTS (strategic, investment, operational, crisis response)
- Available options: Current alternatives under consideration
- Success criteria: Key metrics for decision evaluation
- Resource constraints: Limitations affecting available choices

## Task

Create comprehensive decision tree analysis for optimal choice selection:

**Decision Context**: Use $ARGUMENTS to analyze strategic decisions, investments, operations, or crisis responses

**Decision Framework**:
1. **Option Generation** - Comprehensive alternative identification including hybrid and innovative approaches
2. **Probability Assessment** - Systematic likelihood estimation using base rates, expert judgment, and market data
3. **Expected Value Analysis** - Multi-dimensional value calculation including financial, strategic, and risk factors
4. **Sensitivity Analysis** - Critical assumption testing and break-even analysis
5. **Risk Assessment** - Comprehensive risk identification, impact analysis, and mitigation strategies
6. **Optimization Engine** - Multi-criteria decision analysis with stakeholder preference integration

**Advanced Analytics**: Monte Carlo simulations, real options valuation, decision path optimization, and robustness testing.

**Implementation Integration**: Connect analysis to specific actions, success metrics, and contingency planning.

**Output**: Complete decision tree with probability-weighted outcomes, expected value calculations, risk assessments, and strategic recommendations with implementation guidance.