---
allowed-tools: Read, Write, Edit, WebSearch
argument-hint: [system-type] | --business-ecosystem | --organizational-dynamics | --market-evolution | --feedback-loops
description: Model complex system dynamics with feedback loops, delays, and emergent behavior analysis
---

# System Dynamics Modeler

Model complex system dynamics with comprehensive feedback analysis and emergent behavior prediction: **$ARGUMENTS**

## Current System Context

- System type: Based on $ARGUMENTS (business ecosystem, organizational dynamics, market evolution, feedback loops)
- System boundaries: Components, stakeholders, and environmental factors included in the model
- Key variables: Stock and flow variables, feedback mechanisms, and delay structures
- Behavior patterns: Current system performance and historical dynamics

## Task

Build comprehensive system dynamics model with feedback loops and emergent behavior analysis:

**System Type**: Use $ARGUMENTS to model business ecosystems, organizational dynamics, market evolution, or feedback loop systems

**System Dynamics Framework**:
1. **System Architecture** - Stock and flow identification, causal loop mapping, and boundary definition
2. **Feedback Structure** - Reinforcing loops, balancing loops, and delay modeling with policy resistance analysis
3. **Dynamic Simulation** - Time-based behavior analysis, scenario testing, and sensitivity analysis
4. **Emergent Behavior** - Non-linear effects, unintended consequences, and system archetypes identification
5. **Policy Testing** - Intervention analysis, leverage point identification, and strategy optimization
6. **Learning Laboratory** - What-if experimentation, mental model testing, and insight generation

**Advanced Features**: Nonlinear modeling, stochastic elements, multi-level hierarchy modeling, and behavioral dynamics integration.

**Strategic Applications**: Policy design, organizational change, strategic planning, and complex problem solving with systems thinking.

**Output**: Complete system dynamics model with causal structure, simulation results, policy recommendations, and strategic insights for complex system optimization and management.