---
name: Email Composer
description: Draft professional emails for various contexts including business, technical, and customer communication. Use when the user needs help writing emails or composing professional messages.
---

# Email Composer

## Quick start

Provide context and purpose, and I'll draft an appropriate email.

**What I need:**
- Purpose of email (request, follow-up, announcement, etc.)
- Recipient relationship (colleague, customer, manager, vendor)
- Key points to include
- Desired tone (formal, casual, urgent, friendly)

## Email structure

Standard professional email format:

```
Subject: [Clear, specific subject line]

[Greeting],

[Opening - context/purpose]

[Body - main points]

[Closing - call to action]

[Sign-off]
[Your name]
```

## Common email types

### Request for information

```
Subject: Question about Q4 project timeline

Hi [Name],

I hope this email finds you well. I'm reaching out regarding the Q4 product launch timeline.

Could you provide an update on:
- Current progress on feature development
- Expected completion date for testing phase
- Any blockers or dependencies we should be aware of

This will help us coordinate with the marketing team for the launch materials.

Thanks in advance for your help!

Best regards,
[Your name]
```

### Follow-up email

```
Subject: Following up: Proposal for new payment system

Hi [Name],

I wanted to follow up on the payment system proposal I sent last week. I understand you're busy, so I wanted to make sure it didn't get lost in your inbox.

To recap, the proposed system would:
- Reduce transaction fees by 30%
- Integrate with existing accounting software
- Improve customer checkout experience

I'd be happy to schedule a brief call to discuss any questions you might have.

Looking forward to hearing from you.

Best,
[Your name]
```

### Technical update

```
Subject: API Maintenance Window - [Date]

Team,

This is a reminder that we'll be performing scheduled maintenance on our API infrastructure on [Date] from [Time] to [Time] [Timezone].

During this window:
- API endpoints will be unavailable
- Database will be upgraded to v14
- SSL certificates will be renewed

Expected downtime: 2 hours

What you need to do:
- Notify your users of the planned downtime
- Ensure retry logic is in place for API calls
- Monitor your application after maintenance completes

If you have any concerns or conflicts with this schedule, please let me know by [Date].

Technical details available in our status page: [link]

Thanks,
[Your name]
```

### Customer support

```
Subject: Re: Issue with order #12345

Hi [Customer name],

Thank you for reaching out about your order. I'm sorry to hear you're experiencing this issue.

I've looked into your order (#12345) and found the following:

[Explanation of the issue]

To resolve this, I've:
- [Action taken 1]
- [Action taken 2]

You should see [expected outcome] within [timeframe].

If you continue to experience any problems, please don't hesitate to reply to this email or call us at [phone number].

We appreciate your patience and understanding.

Best regards,
[Your name]
Customer Support Team
```

### Meeting request

```
Subject: Meeting request: Discuss database migration strategy

Hi [Name],

I'd like to schedule a meeting to discuss our approach for the upcoming database migration.

Agenda items:
- Review migration timeline and milestones
- Discuss rollback strategy
- Identify potential risks and mitigation plans
- Assign team responsibilities

Estimated duration: 45 minutes

I'm available:
- Monday 2-4 PM
- Wednesday 10 AM - 12 PM
- Friday 1-3 PM

Please let me know what works best for you, or feel free to suggest alternative times.

Best,
[Your name]
```

## Tone guidelines

### Formal tone
- Use complete sentences
- Avoid contractions
- Professional language
- Proper titles (Dr., Mr., Ms.)

### Casual tone
- Contractions acceptable
- Conversational language
- Still professional
- First names

### Urgent tone
- Clear subject line with [URGENT] or [ACTION REQUIRED]
- Bold key points
- Explicit deadline
- Direct call to action

## Subject line best practices

**Good subject lines:**
- "Action required: Submit timesheet by Friday"
- "Q4 Sales Report - Review needed"
- "Meeting rescheduled: Project kickoff now Thursday"
- "Quick question about deployment process"

**Bad subject lines:**
- "Update"
- "Question"
- "Hello"
- "Following up"

## Email etiquette

**DO:**
- Respond within 24 hours (even if just to acknowledge)
- Use clear, specific subject lines
- Keep it concise
- Proofread before sending
- Include relevant context
- Use bullet points for multiple items
- End with clear call to action

**DON'T:**
- Use ALL CAPS
- Over-use exclamation marks!!!
- Mark everything as urgent
- Reply all unless necessary
- Send when emotional
- Include unnecessary recipients
- Forget attachments mentioned in email

## Templates by scenario

### Decline request politely

```
Subject: Re: [Original subject]

Hi [Name],

Thank you for thinking of me for [request/opportunity].

Unfortunately, I won't be able to [participate/help/attend] due to [brief reason - optional]. However, I'd recommend [alternative suggestion if applicable].

I appreciate your understanding, and I hope we can collaborate on future opportunities.

Best regards,
[Your name]
```

### Apologize for mistake

```
Subject: Apology and correction: [Issue]

Hi [Name],

I'm writing to apologize for [specific mistake]. This was an error on my part, and I take full responsibility.

To correct this:
- [Action 1 already taken]
- [Action 2 in progress]
- [Preventive measure for future]

I understand this may have caused [impact], and I'm committed to ensuring it doesn't happen again.

If you have any concerns or questions, please don't hesitate to reach out.

Sincerely,
[Your name]
```

### Share good news

```
Subject: Great news: [Achievement/milestone]

Team,

I'm excited to share that we've [accomplished goal]!

This success is thanks to:
- [Team/person contribution 1]
- [Team/person contribution 2]

Impact:
- [Metric improvement]
- [Business benefit]

Thank you all for your hard work and dedication. Let's keep up the momentum!

Cheers,
[Your name]
```

## Closing phrases by context

**Formal:**
- Sincerely
- Best regards
- Respectfully
- Cordially

**Professional:**
- Best
- Thanks
- Kind regards
- Regards

**Casual:**
- Cheers
- Thanks!
- Talk soon
- Best

## Email composition checklist

- [ ] Clear, specific subject line
- [ ] Appropriate greeting
- [ ] Purpose stated upfront
- [ ] Key points organized with bullets/numbers
- [ ] Clear call to action or next steps
- [ ] Appropriate tone for audience
- [ ] Proofread for typos
- [ ] Attachments included (if mentioned)
- [ ] Recipients correct (To, CC, BCC)
- [ ] Professional signature
