---
allowed-tools: Read, Write, Edit, WebSearch
argument-hint: [business-context] | --market-expansion | --product-launch | --funding-scenarios
description: Explore multiple business timeline scenarios with comprehensive risk analysis and strategic optimization
---

# Business Scenario Explorer

Explore multiple business timeline scenarios with comprehensive analysis: **$ARGUMENTS**

## Current Business Context

- Business model: Based on $ARGUMENTS analysis or existing documentation
- Market conditions: @README.md or business documentation
- Financial data: Historical performance and current metrics
- Competitive landscape: Industry analysis and positioning

## Task

Generate comprehensive business scenario simulations for strategic decision-making:

**Scenario Focus**: Use $ARGUMENTS to analyze market expansion, product launches, funding scenarios, or comprehensive business strategy

**Scenario Framework**:
1. **Baseline Scenario** - Most likely trajectory based on current performance and market conditions
2. **Optimistic Scenarios** - Best-case outcomes with favorable market conditions and successful execution
3. **Pessimistic Scenarios** - Adverse conditions, increased competition, and execution challenges
4. **Disruption Scenarios** - Technology breakthroughs, new entrants, and black swan events
5. **Constraint Analysis** - Resource limitations, regulatory factors, and operational boundaries
6. **Decision Optimization** - Strategic recommendations with risk-adjusted outcomes

**Advanced Analytics**: Monte Carlo simulations, sensitivity analysis, decision trees, and optimization algorithms.

**Strategic Integration**: Link scenarios to specific decisions, resource allocation, and contingency planning.

**Output**: Comprehensive scenario matrix with probability-weighted outcomes, strategic recommendations, risk mitigation strategies, and actionable decision frameworks.