---
allowed-tools: Read, Write, Edit, WebSearch
argument-hint: [simulation-type] | --business | --technical | --behavioral | --strategic
description: Calibrate simulation accuracy with systematic validation, bias detection, and continuous improvement
---

# Simulation Calibrator

Calibrate simulation accuracy with comprehensive validation and continuous improvement: **$ARGUMENTS**

## Current Simulation State

- Simulation type: Based on $ARGUMENTS (business, technical, behavioral, strategic simulation)
- Accuracy requirements: Mission-critical (95%+), strategic (80-95%), or exploratory (50-70%)
- Validation data: Historical outcomes, real-world benchmarks, and expert assessments
- Performance metrics: Current accuracy levels and improvement opportunities

## Task

Implement systematic simulation calibration with comprehensive accuracy improvement:

**Simulation Type**: Use $ARGUMENTS to calibrate business simulations, technical models, behavioral predictions, or strategic scenarios

**Calibration Framework**:
1. **Baseline Assessment** - Historical validation, accuracy metrics, and error pattern analysis
2. **Bias Detection** - Systematic identification of cognitive, data, and model biases with mitigation strategies
3. **Validation Loops** - Multi-level validation with internal consistency, expert review, and empirical testing
4. **Real-Time Calibration** - Continuous monitoring, automated adjustments, and adaptive learning integration
5. **Quality Assurance** - Meta-calibration assessment and improvement sustainability
6. **Improvement Roadmap** - Systematic enhancement strategies with performance tracking

**Advanced Features**: Automated bias detection, machine learning calibration, cross-simulation learning, and predictive accuracy optimization.

**Quality Control**: Independent validation, benchmark comparison, and comprehensive documentation for institutional learning.

**Output**: Calibrated simulation with validated accuracy metrics, bias correction reports, continuous improvement systems, and enhanced decision support reliability.