---
allowed-tools: Read, Write, Edit, Bash
argument-hint: [analysis-type] | --bias-detection | --scenario-testing | --process-optimization | --outcome-tracking
description: Analyze team decision quality with bias detection, scenario testing, and process improvement recommendations
---

# Decision Quality Analyzer

Analyze and improve team decision-making quality with comprehensive bias detection: **$ARGUMENTS**

## Current Decision Context

- Team size: !`git log --format='%ae' --since='1 month ago' | sort -u | wc -l` active contributors
- Recent decisions: Major decisions from recent commits and discussions
- Decision frequency: Pattern analysis of decision-making cadence
- Process maturity: Current decision frameworks and methodologies in use

## Task

Execute comprehensive decision quality analysis with bias mitigation and process optimization:

**Analysis Type**: Use $ARGUMENTS for bias detection, scenario testing, process optimization, or outcome tracking analysis

**Decision Quality Framework**:
1. **Process Quality Assessment** - Evaluate information gathering, stakeholder involvement, alternative generation, analysis rigor
2. **Bias Detection Analysis** - Identify confirmation bias, anchoring bias, groupthink, authority bias, planning fallacy patterns
3. **Outcome Evaluation** - Assess goal achievement, unintended consequences, stakeholder satisfaction, sustainability measures
4. **Scenario Testing** - Historical decision analysis, hypothetical scenario testing, stress test scenarios, learning extraction
5. **Timing Analysis** - Decision speed evaluation, information timing optimization, implementation coordination, review scheduling
6. **Learning Integration** - Knowledge capture, institutional learning, process improvement, capability building

**Advanced Features**: Multi-dimensional quality metrics, systematic bias mitigation strategies, decision simulation testing, predictive outcome modeling.

**Process Optimization**: Stakeholder engagement frameworks, analytical tool integration, communication enhancement, cultural development strategies.

**Output**: Comprehensive decision quality assessment with specific bias mitigation strategies, process improvements, and implementation roadmap.