# Anthropic Skills Attribution

This directory contains skills from Anthropic's official skills repository:
https://github.com/anthropics/skills

## License Information

The following skills are used under their respective licenses:

### Apache 2.0 License (Open Source)
These skills are freely usable, modifiable, and redistributable:
- `algorithmic-art` - Create generative art using p5.js
- `artifacts-builder` - Build complex HTML artifacts with React and Tailwind
- `brand-guidelines` - Apply Anthropic's brand guidelines
- `canvas-design` - Design visual art in .png and .pdf formats
- `internal-comms` - Write internal communications
- `mcp-builder` - Guide for creating MCP servers
- `skill-creator` - Guide for creating effective skills
- `slack-gif-creator` - Create animated GIFs for Slack
- `theme-factory` - Style artifacts with professional themes
- `webapp-testing` - Test local web applications with Playwright

### Source-Available (Reference Only)
These document skills are provided by Anthropic as reference examples. They are NOT open source:
- `docx` - Create, edit, and analyze Word documents
- `pdf-anthropic` - Comprehensive PDF manipulation toolkit
- `pptx` - Create, edit, and analyze PowerPoint presentations
- `xlsx` - Create, edit, and analyze Excel spreadsheets

**Important:** The document skills are point-in-time snapshots and are not actively maintained. Versions of these skills ship pre-included with Claude. They are primarily intended as reference examples.

## Third-Party Dependencies

Some skills may include third-party dependencies with different licenses:

### GNU GPL v3.0
- **FFmpeg 7.0.2** - Used in video/media processing (if applicable)
- Source: https://ffmpeg.org/releases/ffmpeg-7.0.2.tar.xz

### MIT-CMU License (HPND)
- **Pillow 11.3.0** - Python image processing library
- Copyright © 1997-2011 by Secret Labs AB, Copyright © 1995-2011 by Fredrik Lundh

### SIL Open Font License v1.1
Various fonts used in design skills (see THIRD_PARTY_NOTICES.md in skill directories)

## Usage Guidelines

1. **Open Source Skills (Apache 2.0)**:
   - Free to use, modify, and redistribute
   - Attribution appreciated but not required
   - Can be used in commercial projects

2. **Document Skills (Source-Available)**:
   - Use as reference for learning
   - Do not redistribute as your own
   - Not suitable for production use without proper licensing

3. **Modified Versions**:
   - If you modify these skills, clearly mark your changes
   - Maintain original attribution
   - Respect the original license terms

## Complete License Terms

For complete license terms, see:
- Apache 2.0: https://www.apache.org/licenses/LICENSE-2.0
- GNU GPL v3.0: https://www.gnu.org/licenses/gpl-3.0.html
- Full notices: See `LICENSE.txt` files in individual skill directories

## Acknowledgments

These skills are provided by Anthropic as examples to demonstrate what's possible with Claude's skills system. We are grateful for their contribution to the AI developer community.

For more information about skills, visit:
- https://support.claude.com/en/articles/12512176-what-are-skills
- https://anthropic.com/engineering/equipping-agents-for-the-real-world-with-agent-skills

---

**Last Updated**: October 17, 2025
