"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from Draupnir
// https://github.com/the-draupnir-project/Draupnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynapseAdminCommands = void 0;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const ResolveAlias_1 = require("./ResolveAlias");
const AliasCommands_1 = require("./AliasCommands");
const Ban_1 = require("./Ban");
const CreateBanListCommand_1 = require("./CreateBanListCommand");
const DeactivateCommand_1 = require("./server-admin/DeactivateCommand");
const Help_1 = require("./Help");
const HijackRoomCommand_1 = require("./server-admin/HijackRoomCommand");
const ImportCommand_1 = require("./ImportCommand");
const KickCommand_1 = require("./KickCommand");
const ProtectionsCommands_1 = require("./ProtectionsCommands");
const RedactCommand_1 = require("./RedactCommand");
const Rooms_1 = require("./Rooms");
const Rules_1 = require("./Rules");
const SetDisplayNameCommand_1 = require("./SetDisplayNameCommand");
const SetPowerLevelCommand_1 = require("./SetPowerLevelCommand");
const ShutdownRoomCommand_1 = require("./server-admin/ShutdownRoomCommand");
const StatusCommand_1 = require("./StatusCommand");
const Unban_1 = require("./unban/Unban");
const WatchUnwatchCommand_1 = require("./WatchUnwatchCommand");
const DraupnirCommandTable_1 = require("./DraupnirCommandTable");
const SafeModeCommand_1 = require("./SafeModeCommand");
const ProtectionsShowCommand_1 = require("./ProtectionsShowCommand");
const ProtectionsCapabilitiesCommand_1 = require("./ProtectionsCapabilitiesCommand");
const JoinWaveShortCircuit_1 = require("../protections/JoinWaveShortCircuit");
const Takedown_1 = require("./server-admin/Takedown");
const SuspendCommand_1 = require("./server-admin/SuspendCommand");
const UnrestrictCommand_1 = require("./server-admin/UnrestrictCommand");
const PolicyRemove_1 = require("./unban/PolicyRemove");
// TODO: These commands should all be moved to subdirectories tbh and this
// should be split like an index file for each subdirectory.
exports.SynapseAdminCommands = new interface_manager_1.StandardCommandTable("synapse admin")
    .internCommand(DeactivateCommand_1.SynapseAdminDeactivateCommand, ["deactivate"])
    .internCommand(HijackRoomCommand_1.SynapseAdminHijackRoomCommand, ["hijack", "room"])
    .internCommand(ShutdownRoomCommand_1.SynapseAdminShutdownRoomCommand, ["shutdown", "room"])
    .internCommand(SuspendCommand_1.SynapseAdminSuspendUserCommand, ["suspend"])
    .internCommand(UnrestrictCommand_1.SynpaseAdminUnrestrictUserCommand, ["unrestrict"]);
const DraupnirCommands = new interface_manager_1.StandardCommandTable("draupnir")
    .internCommand(AliasCommands_1.DraupnirAliasMoveCommand, ["alias", "move"])
    .internCommand(AliasCommands_1.DraupnirAliasRemoveCommand, ["alias", "remove"])
    .internCommand(Ban_1.DraupnirBanCommand, ["ban"])
    .internCommand(CreateBanListCommand_1.DraupnirListCreateCommand, ["list", "create"])
    .internCommand(Help_1.DraupnirHelpCommand, ["help"])
    .internCommand(ImportCommand_1.DraupnirImportCommand, ["import"])
    .internCommand(KickCommand_1.DraupnirKickCommand, ["kick"])
    .internCommand(PolicyRemove_1.DraupnirPolicyRemoveCommand, ["policy", "remove"])
    .internCommand(ProtectionsCommands_1.DraupnirListProtectionsCommand, ["protections"])
    .internCommand(ProtectionsCapabilitiesCommand_1.DraupnirProtectionsCapabilityCommand, [
    "protections",
    "capability",
])
    .internCommand(ProtectionsCommands_1.DraupnirProtectionsCapabilityResetCommand, [
    "protections",
    "capability",
    "reset",
])
    .internCommand(ProtectionsCommands_1.DraupnirProtectionsEnableCommand, ["protections", "enable"])
    .internCommand(ProtectionsCommands_1.DraupnirProtectionsDisableCommand, ["protections", "disable"])
    .internCommand(ProtectionsCommands_1.DraupnirProtectionsConfigAddCommand, [
    "protections",
    "config",
    "add",
])
    .internCommand(ProtectionsCommands_1.DraupnirProtectionsConfigRemoveCommand, [
    "protections",
    "config",
    "remove",
])
    .internCommand(ProtectionsCommands_1.DraupnirProtectionsConfigSetCommand, [
    "protections",
    "config",
    "set",
])
    .internCommand(ProtectionsCommands_1.DraupnirProtectionsConfigResetCommand, [
    "protections",
    "config",
    "reset",
])
    .internCommand(ProtectionsShowCommand_1.DraupnirProtectionsShowCommand, ["protections", "show"])
    .internCommand(RedactCommand_1.DraupnirRedactCommand, ["redact"])
    .internCommand(ResolveAlias_1.DraupnirResolveAliasCommand, ["resolve"])
    .internCommand(Rooms_1.DraupnirListProtectedRoomsCommand, ["rooms"])
    .internCommand(Rooms_1.DraupnirRoomsAddCommand, ["rooms", "add"])
    .internCommand(Rooms_1.DraupnirRoomsRemoveCommand, ["rooms", "remove"])
    .internCommand(Rules_1.DraupnirListRulesCommand, ["rules"])
    .internCommand(Rules_1.DraupnirRulesMatchingCommand, ["rules", "matching"])
    .internCommand(Rules_1.DraupnirRulesMatchingMembersCommand, [
    "rules",
    "matching",
    "members",
])
    .internCommand(SafeModeCommand_1.DraupnirSafeModeCommand, ["safe", "mode"])
    .internCommand(SetDisplayNameCommand_1.DraupnirDisplaynameCommand, ["displayname"])
    .internCommand(SetPowerLevelCommand_1.DraupnirSetPowerLevelCommand, ["powerlevel"])
    .internCommand(StatusCommand_1.DraupnirStatusCommand, ["status"])
    .internCommand(Takedown_1.DraupnirTakedownCommand, ["takedown"])
    .internCommand(Unban_1.DraupnirUnbanCommand, ["unban"])
    .internCommand(WatchUnwatchCommand_1.DraupnirWatchPolicyRoomCommand, ["watch"])
    .internCommand(WatchUnwatchCommand_1.DraupnirUnwatchPolicyRoomCommand, ["unwatch"]);
DraupnirCommands.importTable(exports.SynapseAdminCommands, []);
DraupnirCommandTable_1.DraupnirTopLevelCommands.importTable(DraupnirCommands, ["draupnir"]);
DraupnirCommandTable_1.DraupnirTopLevelCommands.importTable(JoinWaveShortCircuit_1.JoinWaveCommandTable, [
    "draupnir",
    "joinwave",
]);
//# sourceMappingURL=DraupnirCommands.js.map