"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynpaseAdminUnrestrictUserCommand = void 0;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const typescript_result_1 = require("@gnuxie/typescript-result");
const UserSuspensionCapability_1 = require("../../protections/HomeserverUserPolicyApplication/UserSuspensionCapability");
const DraupnirCommandPrerequisites_1 = require("../DraupnirCommandPrerequisites");
exports.SynpaseAdminUnrestrictUserCommand = (0, interface_manager_1.describeCommand)({
    summary: "Unrestrict a user on the homeserver if their account has been suspended or shadowbanned",
    parameters: (0, interface_manager_1.tuple)({
        name: "user",
        description: "The user to unrestrict",
        acceptor: interface_manager_1.MatrixUserIDPresentationType,
    }),
    async executor(draupnir, info, _keywords, _rest, targetUser) {
        if (draupnir.synapseAdminClient === undefined ||
            draupnir.stores.userRestrictionAuditLog === undefined) {
            return typescript_result_1.ResultError.Result("This command cannot be used without synapse admin");
        }
        const capability = new UserSuspensionCapability_1.SynapseAdminUserSuspensionCapability(draupnir.synapseAdminClient, draupnir.stores.userRestrictionAuditLog);
        return await capability.unrestrictUser(targetUser.toString(), info.commandSender);
    },
});
DraupnirCommandPrerequisites_1.DraupnirInterfaceAdaptor.describeRenderer(exports.SynpaseAdminUnrestrictUserCommand, {
    isAlwaysSupposedToUseDefaultRenderer: true,
});
//# sourceMappingURL=UnrestrictCommand.js.map