"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardCommandDispatcher = void 0;
const Command_1 = require("../Command");
const PresentationStream_1 = require("../Command/PresentationStream");
const typescript_result_1 = require("@gnuxie/typescript-result");
const TextCommandReader_1 = require("./TextCommandReader");
class StandardCommandDispatcher {
    constructor(commandTable, helpCommand, callbacks) {
        this.commandTable = commandTable;
        this.helpCommand = helpCommand;
        this.callbacks = callbacks;
        // nothing to do.
    }
    parsePartialCommandFromBody(commandInformation, body) {
        var _a, _b;
        // The try is required because readCommand does not return `Result`s and throws errors.
        try {
            const normalisedCommandBody = this.callbacks.commandNormaliser(body);
            if (normalisedCommandBody === undefined) {
                return typescript_result_1.ResultError.Result("No command found in the body.");
            }
            const readResult = (0, TextCommandReader_1.readCommand)(normalisedCommandBody);
            const firstItem = readResult.at(0);
            if (firstItem === undefined || typeof firstItem.object !== "string") {
                return typescript_result_1.ResultError.Result("No command found in the body.");
            }
            return this.parsePartialCommandFromStream(commandInformation, new PresentationStream_1.StandardPresentationArgumentStream(readResult));
        }
        catch (error) {
            if (error instanceof Error) {
                (_b = (_a = this.callbacks).commandUncaughtErrorCB) === null || _b === void 0 ? void 0 : _b.call(_a, commandInformation, body, error);
                if (this.callbacks.convertUncaughtErrorToResultError) {
                    return (0, typescript_result_1.Err)(this.callbacks.convertUncaughtErrorToResultError(error));
                }
                else {
                    throw new TypeError(`Caught an error when parsing a command, please use convertUncaughtErrorToResultError to handle this error and extract information from it.`);
                }
            }
            else {
                throw new TypeError(
                // I don't know what else we're going to do with it...
                // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
                `Something is throwing things that are not errors ${error})}`);
            }
        }
    }
    parsePartialCommandFromStream(commandInformation, stream) {
        var _a, _b, _c;
        (_b = (_a = this.callbacks).logCurrentCommandCB) === null || _b === void 0 ? void 0 : _b.call(_a, commandInformation, stream.source);
        const commandToUse = (_c = this.commandTable.findAMatchingCommand(stream)) !== null && _c !== void 0 ? _c : this.helpCommand;
        const normalisedDesignator = stream.source
            .slice(0, stream.getPosition())
            .map((p) => p.object);
        const partialCommand = (0, Command_1.makePartialCommand)(stream, commandToUse, this.commandTable, normalisedDesignator);
        return (0, typescript_result_1.Ok)(partialCommand);
    }
}
exports.StandardCommandDispatcher = StandardCommandDispatcher;
//# sourceMappingURL=StandardCommandDispatcher.js.map