"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardPaginationIterator = void 0;
// SPDX-FileCopyrightText: 2024 - 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const typescript_result_1 = require("@gnuxie/typescript-result");
class StandardPaginationIterator {
    constructor(startingOptions, paginator) {
        this.startingOptions = startingOptions;
        this.paginator = paginator;
        // nothing to do.
    }
    async forEachItem(options) {
        const isUnderLimit = (count) => options.totalItemLimit === undefined || count < options.totalItemLimit;
        let itemCount = 0;
        const startingPage = await this.paginator.fetchPage(this.startingOptions);
        if ((0, typescript_result_1.isError)(startingPage)) {
            return startingPage.elaborate('Failed to fetch first page when paginating');
        }
        let currentPage = startingPage.ok;
        let isFirstPage = true;
        while (true) {
            let isMarkedAsStop = false;
            for (const item of currentPage.chunk) {
                isMarkedAsStop = !isUnderLimit(itemCount);
                if (isMarkedAsStop) {
                    break;
                }
                options.forEachItemCB(item);
                itemCount++;
            }
            if (isMarkedAsStop) {
                break;
            }
            if (!currentPage.hasNext && !isFirstPage) {
                break; // no more items.
            }
            const nextPageOptions = {
                ...this.startingOptions,
                from: currentPage.nextToken,
            };
            const nextPageResult = await this.paginator.fetchPage(nextPageOptions);
            if ((0, typescript_result_1.isError)(nextPageResult)) {
                return nextPageResult.elaborate('Failed to fetch next page');
            }
            else {
                currentPage = nextPageResult.ok;
            }
            isFirstPage = false;
        }
        return (0, typescript_result_1.Ok)(undefined);
    }
}
exports.StandardPaginationIterator = StandardPaginationIterator;
//# sourceMappingURL=StandardPaginationIterator.js.map