"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardJoinedRoomsRevision = void 0;
const immutable_1 = require("immutable");
class StandardJoinedRoomsRevision {
    constructor(clientUserID, joinedRooms) {
        this.clientUserID = clientUserID;
        this.joinedRooms = joinedRooms;
        // nothing to do.
    }
    get allJoinedRooms() {
        return [...this.joinedRooms];
    }
    isEmpty() {
        return this.joinedRooms.size === 0;
    }
    isJoinedRoom(roomID) {
        return this.joinedRooms.has(roomID);
    }
    isPreemptivelyJoinedRoom(roomID) {
        return this.joinedRooms.has(roomID);
    }
    changesFromJoinedRooms(roomIDs) {
        const updatedJoinedRooms = new Set(roomIDs);
        return {
            joined: roomIDs.filter((roomID) => !this.joinedRooms.has(roomID)),
            parted: this.allJoinedRooms.filter((roomID) => !updatedJoinedRooms.has(roomID)),
        };
    }
    reviseFromJoinedRooms(roomIDs) {
        return new StandardJoinedRoomsRevision(this.clientUserID, (0, immutable_1.Set)(roomIDs));
    }
    static blankRevision(clientUserID) {
        return new StandardJoinedRoomsRevision(clientUserID, (0, immutable_1.Set)());
    }
}
exports.StandardJoinedRoomsRevision = StandardJoinedRoomsRevision;
//# sourceMappingURL=JoinedRoomsRevision.js.map