"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardDeduplicator = void 0;
class StandardDeduplicator {
    constructor(queueMaxSize) {
        this.keySet = new Set();
        this.queue = [];
        this.queueMaxSize = queueMaxSize !== null && queueMaxSize !== void 0 ? queueMaxSize : 32;
    }
    isDuplicate(key) {
        if (this.keySet.has(key)) {
            return true;
        }
        if (this.queue.length === this.queueMaxSize) {
            const keyToRemove = this.queue.shift();
            if (keyToRemove === undefined) {
                throw new TypeError(`The keyToRemove should not be undefined`);
            }
            this.keySet.delete(keyToRemove);
        }
        this.keySet.add(key);
        this.queue.push(key);
        return false;
    }
}
exports.StandardDeduplicator = StandardDeduplicator;
//# sourceMappingURL=Deduplicator.js.map