"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SchemedDataManager = exports.DRAUPNIR_SCHEMA_VERSION_KEY = void 0;
// Copyright (C) 2023 - 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const Action_1 = require("./Action");
exports.DRAUPNIR_SCHEMA_VERSION_KEY = 'ge.applied-langua.ge.draupnir.schema_version';
class SchemedDataManager {
    constructor(migrationSchema, versionKey = exports.DRAUPNIR_SCHEMA_VERSION_KEY) {
        this.migrationSchema = migrationSchema;
        this.versionKey = versionKey;
        // nothing to do.
    }
    async migrateData(rawData) {
        var _a;
        // The cast is required because I think, although have not confirmed,
        // TypeScript believes `keyof TSchema` can be any key and not just one
        // that correlates to `Version`. This is a really nasty and complicated
        // mismatch to narrow down.
        const startingVersion = (_a = rawData[this.versionKey]) !== null && _a !== void 0 ? _a : 0;
        // Rememeber, version 0 has no migrations
        if (this.migrationSchema.length < startingVersion) {
            return Action_1.ActionError.Result(`Encountered a version that we do not have migrations for ${startingVersion}`);
        }
        else if (this.migrationSchema.length === startingVersion) {
            return (0, Action_1.Ok)(rawData);
        }
        else {
            const applicableSchema = this.migrationSchema.slice(startingVersion);
            const migratedData = await applicableSchema.reduce(async (previous, schema, schemaIndex) => {
                const previousResult = await previous;
                if ((0, Action_1.isError)(previousResult)) {
                    return previousResult;
                }
                return await schema(previousResult.ok, schemaIndex + 1);
            }, Promise.resolve((0, Action_1.Ok)(rawData)));
            return migratedData;
        }
    }
    get latestVersion() {
        return this.migrationSchema.length;
    }
}
exports.SchemedDataManager = SchemedDataManager;
//# sourceMappingURL=SchemedMatrixData.js.map