import { RoomStateRevisionIssuer } from '../StateTracking/StateRevisionIssuer';
import { RoomStateEventSender } from '../Client/RoomStateEventSender';
import { PolicyListRevisionIssuer } from './PolicyListRevisionIssuer';
import { PolicyRoomEditor, TakedownPolicyOption } from './PolicyRoomEditor';
import { PolicyRuleType } from '../MatrixTypes/PolicyEvents';
import { PolicyRule, Recommendation } from './PolicyRule';
import { ActionResult } from '../Interface/Action';
import { MatrixRoomID, StringEventID } from '@the-draupnir-project/matrix-basic-types';
export declare class StandardPolicyRoomEditor implements PolicyRoomEditor {
    readonly room: MatrixRoomID;
    private readonly policyRevisionIssuer;
    private readonly roomStateRevisionIssuer;
    private readonly roomStateEventSender;
    constructor(room: MatrixRoomID, policyRevisionIssuer: PolicyListRevisionIssuer, roomStateRevisionIssuer: RoomStateRevisionIssuer, roomStateEventSender: RoomStateEventSender);
    removePolicyByStateKey(ruleType: PolicyRuleType, stateKey: string): Promise<ActionResult<void>>;
    createPolicy(entityType: PolicyRuleType, recommendation: Recommendation, entity: string, reason: string, additionalProperties: Record<string, unknown>): Promise<ActionResult<string>>;
    removePolicy(ruleType: PolicyRuleType, recommendation: Recommendation, entity: string, _reason?: string | undefined): Promise<ActionResult<PolicyRule[]>>;
    banEntity(ruleType: PolicyRuleType, entity: string, reason?: string | undefined): Promise<ActionResult<string>>;
    takedownEntity(ruleType: PolicyRuleType, entity: string, options: TakedownPolicyOption): Promise<ActionResult<StringEventID>>;
    unbanEntity(ruleType: PolicyRuleType, entity: string): Promise<ActionResult<PolicyRule[]>>;
}
//# sourceMappingURL=StandardPolicyRoomEditor.d.ts.map