"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimulatedServerConsequences = void 0;
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const typescript_result_1 = require("@gnuxie/typescript-result");
const CapabilityProvider_1 = require("../CapabilityProvider");
const ServerACLConsequences_1 = require("./ServerACLConsequences");
const EventGeneration_1 = require("../../../TestUtilities/EventGeneration");
const FakeStateSender = Object.freeze({
    sendStateEvent(_room, _stateType, _stateKey, _content) {
        return Promise.resolve((0, typescript_result_1.Ok)((0, EventGeneration_1.randomEventID)()));
    },
});
class SimulatedServerConsequences {
    constructor(protectedRoomsSet) {
        this.protectedRoomsSet = protectedRoomsSet;
        this.requiredPermissions = [];
        this.requiredEventPermissions = [];
        this.requiredStatePermissions = [];
        this.isSimulated = true;
        this.simulatedCapability = new ServerACLConsequences_1.ServerACLConequences(FakeStateSender, this.protectedRoomsSet);
        // nothing to do.
    }
    async consequenceForServersInRoom(roomID, issuer) {
        return await this.simulatedCapability.consequenceForServersInRoom(roomID, issuer);
    }
    async consequenceForServersInRoomSet(issuer) {
        return await this.simulatedCapability.consequenceForServersInRoomSet(issuer);
    }
    async unbanServerFromRoomSet(serverName, reason) {
        return await this.simulatedCapability.unbanServerFromRoomSet(serverName, reason);
    }
}
exports.SimulatedServerConsequences = SimulatedServerConsequences;
(0, CapabilityProvider_1.describeCapabilityProvider)({
    name: 'SimulatedServerConsequences',
    description: 'Simulates banning servers in protected rooms, but has no real effects',
    interface: 'ServerConsequences',
    isSimulated: true,
    factory(_description, context) {
        return new SimulatedServerConsequences(context.protectedRoomsSet);
    },
});
//# sourceMappingURL=SimulatedServerConsequences.js.map