"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UNDECODABLE_CONTENT_EVENT_TYPE = void 0;
exports.isUndecodableEvent = isUndecodableEvent;
exports.decodeEventWithUndecodableContent = decodeEventWithUndecodableContent;
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const typescript_result_1 = require("@gnuxie/typescript-result");
const Events_1 = require("../MatrixTypes/Events");
const Value_1 = require("../Interface/Value");
const typebox_1 = require("@sinclair/typebox");
const SafeMembershipEvent_1 = require("./SafeMembershipEvent");
exports.UNDECODABLE_CONTENT_EVENT_TYPE = 'me.marewolf.undecodable_content';
const RoomEventWithUnknownContent = (0, Events_1.RoomEvent)(typebox_1.Type.Unknown());
function isUndecodableEvent(event) {
    return (event.type === exports.UNDECODABLE_CONTENT_EVENT_TYPE &&
        SafeMembershipEvent_1.UnsafeContentKey in event &&
        typeof event.originalType === 'string');
}
function decodeEventWithUndecodableContent(event) {
    const decodeResult = Value_1.Value.Decode(RoomEventWithUnknownContent, event);
    if ((0, typescript_result_1.isError)(decodeResult)) {
        return decodeResult;
    }
    const decodedEvent = decodeResult.ok;
    return (0, typescript_result_1.Ok)({
        ...decodedEvent,
        type: exports.UNDECODABLE_CONTENT_EVENT_TYPE,
        originalType: decodedEvent.type,
        [SafeMembershipEvent_1.UnsafeContentKey]: decodedEvent.content,
        content: {},
    });
}
//# sourceMappingURL=UndecodableEventContent.js.map