import { StringEventID } from '@the-draupnir-project/matrix-basic-types';
export interface Batcher<Key extends string, Value> {
    add(key: Key, value: Value): void;
    dispose(): void;
}
export declare class StandardBatcher<Key extends string, Value> implements Batcher<Key, Value> {
    private readonly batchFactoryMethod;
    private currentBatch;
    constructor(batchFactoryMethod: () => Batch<Key, Value>);
    add(key: Key, value: Value): void;
    dispose(): void;
}
export interface Batch<Key extends string, Value> {
    add(key: Key, data: Value): void;
    isFinished(): boolean;
    batchCompleteCallback: (entries: [Key, Value][]) => Promise<void>;
    cancel(): void;
}
export declare class ConstantPeriodItemBatch<Key extends string, Value> implements Batch<Key, Value> {
    readonly batchCompleteCallback: Batch<Key, Value>['batchCompleteCallback'];
    private readonly waitPeriodMS;
    private items;
    private isBatchComplete;
    private timeoutID;
    constructor(batchCompleteCallback: Batch<Key, Value>['batchCompleteCallback'], { waitPeriodMS }: {
        waitPeriodMS?: number | undefined;
    });
    isFinished(): boolean;
    add(key: Key, item: Value): void;
    private startCallbackTimer;
    private completeBatch;
    cancel(): void;
}
type EventWithID = {
    event_id: StringEventID;
};
export interface EventBatch<E extends EventWithID = EventWithID> {
    addEvent({ event_id }: E): void;
    isFinished(): boolean;
    batchCompleteCallback: (events: E[]) => Promise<void>;
}
export declare class ConstantPeriodEventBatch<E extends EventWithID = EventWithID> implements EventBatch<E> {
    readonly batchCompleteCallback: EventBatch['batchCompleteCallback'];
    private readonly batch;
    constructor(batchCompleteCallback: EventBatch['batchCompleteCallback'], { waitPeriodMS }: {
        waitPeriodMS?: number | undefined;
    });
    isFinished(): boolean;
    addEvent(event: E): void;
}
export {};
//# sourceMappingURL=EventBatch.d.ts.map