import type * as ts from 'typescript';
import { Scope } from '../scope/scope';
import { ModuleName } from './modules/moduleName';
export declare class MockDefiner {
    private _moduleImportIdentifierPerFile;
    private _factoryRegistrationsPerFile;
    private _hydratedFactoryRegistrationsPerFile;
    private _factoryIntersectionsRegistrationsPerFile;
    private _factoryCache;
    private _hydratedFactoryCache;
    private _registerMockFactoryCache;
    private _declarationCache;
    private _hydratedDeclarationCache;
    private _factoryIntersectionCache;
    private _fileName;
    private _factoryUniqueName;
    private readonly _cacheEnabled;
    private constructor();
    private static _instance;
    static get instance(): MockDefiner;
    setFileNameFromNode(node: ts.Node): void;
    setTsAutoMockImportIdentifier(): void;
    getCurrentModuleIdentifier(module: ModuleName): ts.Identifier;
    getTopStatementsForFile(sourceFile: ts.SourceFile): ts.Statement[];
    initFile(sourceFile: ts.SourceFile): void;
    createMockFactory(declaration: ts.Declaration, scope: Scope): void;
    getMockFactoryTypeofEnum(declaration: ts.EnumDeclaration, scope: Scope): ts.Expression;
    getMockFactoryIntersection(declarations: ts.Declaration[], type: ts.IntersectionTypeNode, scope: Scope): ts.Expression;
    getMockFactoryByKey(key: string): ts.Expression;
    getDeclarationKeyMapBasedOnScope(declaration: ts.Declaration, scope: Scope): string;
    registerMockFor(declaration: ts.Declaration, factory: ts.FunctionExpression): ts.Node;
    hasMockForDeclaration(declaration: ts.Declaration, scope: Scope): boolean;
    private _getDeclarationKeyMap;
    private _getHydratedDeclarationKeyMap;
    private _mockRepositoryAccess;
    private _getModuleIdentifier;
    private _getMockFactoryIdForTypeofEnum;
    private _getMockFactoryIdForIntersections;
    private _getImportsToAddInFile;
    private _getExportsToAddInFile;
    private _getHydratedExportsToAddInFile;
    private _getExportsIntersectionToAddInFile;
    private _createRegistration;
    private _wrapRegisterMockFactory;
    private _getCallRegisterMock;
    private _getCallGetFactory;
    private _getMockGenericParameter;
}
