"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
const typebox_1 = require("@sinclair/typebox");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const UserRestrictionCapability = typebox_1.Type.Object({
    unrestrictUser: matrix_protection_suite_1.CapabilityMethodSchema,
    restrictUser: matrix_protection_suite_1.CapabilityMethodSchema,
    isUserRestricted: matrix_protection_suite_1.CapabilityMethodSchema,
});
(0, matrix_protection_suite_1.describeCapabilityInterface)({
    name: "UserRestrictionCapability",
    description: "Capabilities to restrict and unrestrict users from the homeserver",
    schema: UserRestrictionCapability,
});
//# sourceMappingURL=UserRestrictionCapability.js.map