"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.deactivateUser = deactivateUser;
const typescript_result_1 = require("@gnuxie/typescript-result");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const matrix_protection_suite_for_matrix_bot_sdk_1 = require("matrix-protection-suite-for-matrix-bot-sdk");
const log = new matrix_protection_suite_1.Logger("deactivateUser");
async function deactivateUser(userID, synapseAdminClient, userAuditLog, options) {
    const userDetails = await synapseAdminClient.getUserDetails(userID);
    if ((0, typescript_result_1.isError)(userDetails)) {
        log.error("Unable to query user details", userID);
        return userDetails;
    }
    if (userDetails.ok?.deactivated) {
        log.debug("User is already deactivated");
        return (0, typescript_result_1.Ok)(undefined);
    }
    const deactivationResult = await synapseAdminClient.deactivateUser(userID, {
        erase: true,
    });
    if ((0, typescript_result_1.isError)(deactivationResult)) {
        return deactivationResult;
    }
    const auditResult = await userAuditLog.recordUserRestriction(userID, matrix_protection_suite_for_matrix_bot_sdk_1.AccountRestriction.Deactivated, options);
    if ((0, typescript_result_1.isError)(auditResult)) {
        log.error("Unable to audit deactivation", userID);
    }
    return deactivationResult;
}
//# sourceMappingURL=deactivateUser.js.map