"use strict";
// Copyright 2023 - 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppserviceBotHelpCommand = void 0;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const AppserviceBotCommandTable_1 = require("./AppserviceBotCommandTable");
const AppserviceBotInterfaceAdaptor_1 = require("./AppserviceBotInterfaceAdaptor");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
const config_1 = require("../../config");
exports.AppserviceBotHelpCommand = (0, interface_manager_1.describeCommand)({
    rest: {
        name: "command parts",
        acceptor: interface_manager_1.TopPresentationSchema,
    },
    summary: "Display this message",
    executor: async function (_context, _keywords, ..._args) {
        return (0, matrix_protection_suite_1.Ok)(AppserviceBotCommandTable_1.AppserviceBotCommands);
    },
    parameters: [],
});
function renderAppserviceBotHelp() {
    return (0, matrix_protection_suite_1.Ok)(interface_manager_1.DeadDocumentJSX.JSXFactory("root", null, (0, mps_interface_adaptor_1.renderTableHelp)(AppserviceBotCommandTable_1.AppserviceBotCommands, config_1.DOCUMENTATION_URL)));
}
AppserviceBotInterfaceAdaptor_1.AppserviceBotInterfaceAdaptor.describeRenderer(exports.AppserviceBotHelpCommand, {
    JSXRenderer: renderAppserviceBotHelp,
});
//# sourceMappingURL=AppserviceBotHelp.js.map