"use strict";
// Copyright 2022 - 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppserviceCommandHandler = void 0;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const AppserviceBotCommandDispatcher_1 = require("./AppserviceBotCommandDispatcher");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
require("./AppserviceBotCommands");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
class AppserviceCommandHandler {
    constructor(clientUserID, client, adminRoomID, clientPlatform, appservice) {
        this.clientUserID = clientUserID;
        this.client = client;
        this.adminRoomID = adminRoomID;
        this.clientPlatform = clientPlatform;
        this.appservice = appservice;
        this.reactionHandler = new mps_interface_adaptor_1.MatrixReactionHandler(this.appservice.accessControlRoomID, this.appservice.botUserID, clientPlatform);
        this.appserviceContext = {
            appservice: this.appservice,
            commandRoomID: this.adminRoomID,
            client: this.client,
            clientPlatform: this.clientPlatform,
            clientUserID: this.clientUserID,
            reactionHandler: this.reactionHandler,
        };
        this.commandDispatcher = (0, AppserviceBotCommandDispatcher_1.makeAppserviceBotCommandDispatcher)(this.appserviceContext);
        this.reactionHandler.on(mps_interface_adaptor_1.ARGUMENT_PROMPT_LISTENER, (0, mps_interface_adaptor_1.makeListenerForArgumentPrompt)(this.adminRoomID, this.commandDispatcher, this.reactionHandler));
        this.reactionHandler.on(mps_interface_adaptor_1.DEFAUILT_ARGUMENT_PROMPT_LISTENER, (0, mps_interface_adaptor_1.makeListenerForPromptDefault)(this.adminRoomID, this.commandDispatcher, this.reactionHandler));
        this.JSInterfaceDispatcher = (0, AppserviceBotCommandDispatcher_1.makeAppserviceJSCommandDispatcher)(this.appserviceContext);
    }
    handleEvent(mxEvent) {
        if (mxEvent.room_id !== this.adminRoomID) {
            return;
        }
        const parsedEventResult = matrix_protection_suite_1.Value.Decode(matrix_protection_suite_1.RoomMessage, mxEvent);
        if ((0, matrix_protection_suite_1.isError)(parsedEventResult)) {
            return;
        }
        const parsedEvent = parsedEventResult.ok;
        const body = typeof mxEvent.content["body"] === "string"
            ? mxEvent.content["body"]
            : "";
        this.commandDispatcher.handleCommandMessageEvent({
            event: parsedEvent,
            roomID: parsedEvent.room_id,
        }, body);
    }
    async sendTextCommand(sender, command) {
        return await this.JSInterfaceDispatcher.invokeCommandFromBody({ commandSender: sender }, command);
    }
    async sendPresentationCommand(sender, ...items) {
        return await this.JSInterfaceDispatcher.invokeCommandFromPresentationStream({ commandSender: sender }, new interface_manager_1.StandardPresentationArgumentStream(items));
    }
}
exports.AppserviceCommandHandler = AppserviceCommandHandler;
//# sourceMappingURL=AppserviceCommandHandler.js.map