"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.findPoliciesToRemove = findPoliciesToRemove;
exports.unbanEntity = unbanEntity;
// So the purpose of this is just to remove all policies related to an entity.
// Prompt which policies will be removed, and then remove them if it's accepted.
// For finer control, they will need to use policy remove command.
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const typescript_result_1 = require("@gnuxie/typescript-result");
function findPoliciesToRemove(entity, watchedPolicyRooms) {
    const entityType = entity instanceof matrix_basic_types_1.MatrixRoomID
        ? matrix_protection_suite_1.PolicyRuleType.Room
        : matrix_protection_suite_1.PolicyRuleType.Server;
    const matches = [];
    for (const profile of watchedPolicyRooms.allRooms) {
        matches.push({
            room: profile.room,
            roomID: profile.room.toRoomIDOrAlias(),
            profile,
            matches: [matrix_protection_suite_1.Recommendation.Ban, matrix_protection_suite_1.Recommendation.Takedown].flatMap((recommendation) => profile.revision.allRulesMatchingEntity(entity.toString(), {
                type: entityType,
                searchHashedRules: true,
                recommendation,
            })),
        });
    }
    return {
        entity,
        policyMatchesToRemove: matches,
    };
}
async function unbanEntity(entity, policyRoomManager, policyMatches) {
    const entityType = (0, matrix_basic_types_1.isStringRoomID)(entity)
        ? matrix_protection_suite_1.PolicyRuleType.Room
        : matrix_protection_suite_1.PolicyRuleType.Server;
    const policiesRemoved = new matrix_protection_suite_1.RoomSetResultBuilder();
    for (const matches of policyMatches.policyMatchesToRemove) {
        const editor = await policyRoomManager.getPolicyRoomEditor(matches.room);
        if ((0, typescript_result_1.isError)(editor)) {
            policiesRemoved.addResult(matches.roomID, editor.elaborate("Unable to obtain the policy room editor"));
        }
        else {
            policiesRemoved.addResult(matches.roomID, (await editor.ok.unbanEntity(entityType, entity)));
        }
    }
    return (0, typescript_result_1.Ok)({
        ...policyMatches,
        policyRemovalResult: policiesRemoved.getResult(),
    });
}
//# sourceMappingURL=UnbanEntity.js.map