"use strict";
// Copyright 2022 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019, 2020 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("path"));
const healthz_1 = require("./health/healthz");
const matrix_bot_sdk_1 = require("matrix-bot-sdk");
const config_1 = require("./config");
const utils_1 = require("./utils");
const DraupnirBotMode_1 = require("./DraupnirBotMode");
const matrix_protection_suite_for_matrix_bot_sdk_1 = require("matrix-protection-suite-for-matrix-bot-sdk");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const DraupnirStores_1 = require("./backingstore/DraupnirStores");
void (async function () {
    const config = (0, config_1.configRead)();
    matrix_bot_sdk_1.LogService.setLevel(matrix_bot_sdk_1.LogLevel.fromString(config.logLevel, matrix_bot_sdk_1.LogLevel.DEBUG));
    matrix_bot_sdk_1.LogService.info("index", "Starting bot...");
    // Initialize error reporting as early as possible.
    if (config.health.sentry) {
        (0, utils_1.initializeSentry)(config);
    }
    const healthz = new healthz_1.Healthz(config);
    healthz.isHealthy = false; // start off unhealthy
    if (config.health.healthz.enabled) {
        healthz.listen();
    }
    let bot = null;
    let client;
    try {
        const storagePath = (0, config_1.getStoragePath)(config.dataPath);
        const storage = new matrix_bot_sdk_1.SimpleFsStorageProvider(path.join(storagePath, "bot.json"));
        if (config.pantalaimon.use && !config.experimentalRustCrypto) {
            const pantalaimon = new matrix_bot_sdk_1.PantalaimonClient(config.homeserverUrl, storage);
            client = await pantalaimon.createClientWithCredentials(config.pantalaimon.username, config.pantalaimon.password);
        }
        else if (config.experimentalRustCrypto) {
            if (config.pantalaimon.use) {
                throw Error("You have a pantalaimon config activated and experimentalRustCrypto. Make sure the accessToken is set and pantalaimon is disabled!");
            }
            const cryptoStorage = new matrix_bot_sdk_1.RustSdkCryptoStorageProvider(path.join(storagePath, "crypto"), 0 /* StoreType.Sqlite */);
            client = new matrix_bot_sdk_1.MatrixClient(config.homeserverUrl, config.accessToken, storage, cryptoStorage);
        }
        else {
            client = new matrix_bot_sdk_1.MatrixClient(config.homeserverUrl, config.accessToken, storage);
        }
        const eventDecoder = matrix_protection_suite_1.DefaultEventDecoder;
        const stores = (0, DraupnirStores_1.makeTopLevelStores)(storagePath, eventDecoder, {
            isRoomStateBackingStoreEnabled: config.roomStateBackingStore.enabled ?? false,
        });
        bot = await DraupnirBotMode_1.DraupnirBotModeToggle.create(client, new matrix_protection_suite_for_matrix_bot_sdk_1.SafeMatrixEmitterWrapper(client, eventDecoder), config, stores);
        // We don't want to send the status on start, as we need to initialize e2ee first (using client.start);
        (await bot.startFromScratch({ sendStatusOnStart: false })).expect("Failed to start Draupnir");
    }
    catch (err) {
        console.error(`Failed to setup draupnir from the config ${config.dataPath}: ${err}`);
        await bot?.stopEverything();
        throw err;
    }
    try {
        await client.start();
        await bot.encryptionInitialized();
        healthz.isHealthy = true;
    }
    catch (err) {
        console.error(`Draupnir failed to start: ${err}`);
        await bot.stopEverything();
        throw err;
    }
})();
//# sourceMappingURL=index.js.map