import { ActionError, ActionResult, RoomEvent, RoomMessageSender } from "matrix-protection-suite";
import { MatrixRoomReference } from "@the-draupnir-project/matrix-basic-types";
import { CommandDescription, BaseCommandTableEntry, DocumentNode, ParameterDescription, CommandTable, Command, LeafNode } from "@the-draupnir-project/interface-manager";
import { MatrixAdaptorContext, MatrixEventContext } from "./MPSMatrixInterfaceAdaptor";
import { Result } from "@gnuxie/typescript-result";
import { RoomReactionSender } from "matrix-protection-suite/dist/Client/RoomReactionSender";
export declare function renderParameterDescription(description: ParameterDescription): DocumentNode;
export declare function renderCommandSummary(command: CommandDescription, tableEntry: BaseCommandTableEntry): DocumentNode;
export declare function renderCommandHelp(command: CommandDescription, designator: string[]): string;
export declare function renderErrorDetails(error: ActionError): DocumentNode;
export declare function replyToEventWithErrorDetails(roomMessageSender: RoomMessageSender, event: RoomEvent, error: ActionError): Promise<Result<void>>;
export declare function renderActionResultToEvent(roomMessageSender: RoomMessageSender, roomReactionSender: RoomReactionSender, event: RoomEvent, result: ActionResult<void>): void;
export declare function reactToEventWithResult(roomReactionSender: RoomReactionSender, event: RoomEvent, result: ActionResult<unknown>): Promise<ActionResult<void>>;
export declare function matrixCommandRenderer<TAdaptorContext extends MatrixAdaptorContext, TEventContext extends MatrixEventContext>({ clientPlatform, commandRoomID }: TAdaptorContext, { event }: TEventContext, _command: Command, result: Result<unknown>): Promise<Result<void>>;
export declare function renderMentionPill(mxid: string, displayName: string): DocumentNode;
export declare function renderRoomPill(room: MatrixRoomReference): DocumentNode;
export declare function renderTableHelp(table: CommandTable, documentationURL: string): DocumentNode;
export declare function wrapInRoot(node: DocumentNode | LeafNode | (DocumentNode | LeafNode)[]): DocumentNode;
//# sourceMappingURL=MatrixHelpRenderer.d.ts.map