"use strict";
/**
 * Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
 * All rights reserved.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeJoinedRoomsSafe = makeJoinedRoomsSafe;
const matrix_protection_suite_1 = require("matrix-protection-suite");
function makeJoinedRoomsSafe(client, clientUserID) {
    return () => {
        return client.getJoinedRooms().then((rooms) => (0, matrix_protection_suite_1.Ok)(rooms), (exception) => matrix_protection_suite_1.ActionException.Result(`Unable to fetch the joined rooms for ${clientUserID}`, {
            exception,
            exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown,
        }));
    };
}
//# sourceMappingURL=JoinedRoomsSafe.js.map