import { StringRoomID } from '@the-draupnir-project/matrix-basic-types';
import { RoomEvent } from '../MatrixTypes/Events';
export type OnRoomEventActivity = (roomID: StringRoomID, events: RoomEvent[]) => void;
/**
 * This is a helper to turn clients that give us a per event handler back into
 * something that bundles events together.
 * If you can avoid doing this by writing your own sync loop or `/transactions`
 * handler, then do so because this is going to suck a little.
 * https://github.com/Gnuxie/matrix-protection-suite/issues/14
 */
export declare class OnEventToOnRoomEventActivityConverter {
    private readonly cb;
    private readonly eventsByRoom;
    private batcher;
    private readonly batchHandler;
    constructor(cb: OnRoomEventActivity);
    private internRoomEvent;
    handleTimelineEvent(roomID: StringRoomID, event: RoomEvent): void;
    private handleBatch;
}
//# sourceMappingURL=RoomEventAcivity.d.ts.map