"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomUpdateException = exports.PermissionError = exports.RoomActionError = void 0;
const Action_1 = require("./Action");
const ActionException_1 = require("./ActionException");
class RoomActionError extends Action_1.ActionError {
    constructor(room, message, elaborations = []) {
        super(message, elaborations);
        this.room = room;
    }
    static Result(message, { room }) {
        return (0, Action_1.ResultError)(new PermissionError(room, message));
    }
    static fromActionError(room, error) {
        if (error instanceof ActionException_1.ActionException) {
            return RoomUpdateException.fromActionException(room, error);
        }
        else if (error instanceof RoomActionError) {
            return error;
        }
        else {
            return new RoomActionError(room, error.message, error.getElaborations());
        }
    }
}
exports.RoomActionError = RoomActionError;
class PermissionError extends RoomActionError {
}
exports.PermissionError = PermissionError;
class RoomUpdateException extends ActionException_1.ActionException {
    constructor(room, ...args) {
        super(...args);
        this.room = room;
    }
    static Result(message, options) {
        return (0, Action_1.ResultError)(new RoomUpdateException(options.room, options.exceptionKind, options.exception, message));
    }
    static fromActionException(room, error) {
        return new RoomUpdateException(room, error.exceptionKind, error.exception, error.message, {
            uuid: error.uuid,
            suppressLog: true,
            elaborations: error.getElaborations(),
        });
    }
}
exports.RoomUpdateException = RoomUpdateException;
//# sourceMappingURL=RoomUpdateError.js.map