import { Logger } from '../Logging/Logger';
import { ActionError } from './Action';
type TaskErrorOptions = {
    description?: string;
    log?: Logger;
} | undefined;
/**
 * An error reporter should destructure `ActionException`s to get all of the
 * context and the referenced uuid.
 */
export type TaskErrorReporter = (error: ActionError, options: TaskErrorOptions) => void;
/**
 * Allows the reporter for all failed tasks to be set.
 * @param reporter A function that implements `TaskErrorReporter`.
 * @see {@link TaskErrorReporter}.
 */
export declare function setGlobalTaskReporter(reporter: TaskErrorReporter): void;
/**
 * Sometimes an `Action` takes place in the background usually a result of an
 * event listener. This means that any errors that are experienced will not
 * have a direct way to reach the user of the application.
 *
 * Up until now, the doctrine for this situation has been to simply log
 * at the error level and move on. However, as a background task failing
 * silently is distinct from simply reporting an error to the error level,
 * we believe that the ability for a consumer of the library to configure
 * what happens to these errors is important.
 */
export declare function Task(task: Promise<unknown>, options?: TaskErrorOptions): Promise<void>;
export {};
//# sourceMappingURL=Task.d.ts.map