"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FakeRoomMembershipRevisionIssuer = void 0;
const RoomStateMembershipRevisionIssuer_1 = require("./RoomStateMembershipRevisionIssuer");
class FakeRoomMembershipRevisionIssuer extends RoomStateMembershipRevisionIssuer_1.RoomStateMembershipRevisionIssuer {
    constructor(room, currentRevision, roomStateRevisionIssuer) {
        super(room, currentRevision, roomStateRevisionIssuer);
        this.revisionLog = [];
    }
    emit(event, nextRevision, changes, previousRevision) {
        // I can see why this rule exists but it's not appropriate here, as we don't
        // really know the context that this fake might gets used in (maybe js?).
        // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
        if (event !== 'revision') {
            throw new TypeError(`FakeRoomMembershipRevisionIssuer was only written for the revision event`);
        }
        this.revisionLog.push([nextRevision, changes, previousRevision]);
        return super.emit(event, nextRevision, changes, previousRevision);
    }
    // These methods are on the Fake's reflective side
    getLastRevision() {
        const revisionEntry = this.revisionLog.at(-1);
        if (revisionEntry === undefined) {
            throw new TypeError(`the revision log is empty`);
        }
        return revisionEntry;
    }
    getNumberOfRevisions() {
        return this.revisionLog.length;
    }
}
exports.FakeRoomMembershipRevisionIssuer = FakeRoomMembershipRevisionIssuer;
//# sourceMappingURL=FakeRoomMembershipRevisionIssuer.js.map