"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerConsequences = void 0;
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const typebox_1 = require("@sinclair/typebox");
const CapabilityMethodSchema_1 = require("./CapabilityMethodSchema");
const CapabilityInterface_1 = require("../CapabilityInterface");
const CapabilityProvider_1 = require("../CapabilityProvider");
exports.ServerConsequences = typebox_1.Type.Intersect([
    typebox_1.Type.Object({
        consequenceForServersInRoom: CapabilityMethodSchema_1.CapabilityMethodSchema,
        consequenceForServersInRoomSet: CapabilityMethodSchema_1.CapabilityMethodSchema,
        unbanServerFromRoomSet: CapabilityMethodSchema_1.CapabilityMethodSchema,
    }),
    CapabilityProvider_1.Capability,
]);
(0, CapabilityInterface_1.describeCapabilityInterface)({
    name: 'ServerConsequences',
    description: 'Capabilities for taking consequences against a server',
    schema: exports.ServerConsequences,
});
//# sourceMappingURL=ServerConsequences.js.map