"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MJOLNIR_PROTECTED_ROOMS_EVENT_TYPE = exports.MjolnirProtectedRoomsEvent = void 0;
// Copyright 2022 - 2023 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 2022 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
const typebox_1 = require("@sinclair/typebox");
const Value_1 = require("../../Interface/Value");
const StringlyTypedMatrix_1 = require("../../MatrixTypes/StringlyTypedMatrix");
exports.MjolnirProtectedRoomsEvent = typebox_1.Type.Object({
    rooms: typebox_1.Type.Array(StringlyTypedMatrix_1.StringRoomIDSchema),
});
Value_1.Value.Compile(exports.MjolnirProtectedRoomsEvent);
exports.MJOLNIR_PROTECTED_ROOMS_EVENT_TYPE = 'org.matrix.mjolnir.protected_rooms';
//# sourceMappingURL=MjolnirProtectedRoomsEvent.js.map