"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const typescript_result_1 = require("@gnuxie/typescript-result");
const FakePersistentMatrixData_1 = require("../../Interface/FakePersistentMatrixData");
const LoggableConfig_1 = require("../../Interface/LoggableConfig");
const SchemedMatrixData_1 = require("../../Interface/SchemedMatrixData");
const MjolnirEnabledProtectionsEvent_1 = require("./MjolnirEnabledProtectionsEvent");
const StandardProtectionsConfig_1 = require("./StandardProtectionsConfig");
const Value_1 = require("../../Interface/Value");
require("../StandardProtections/MemberBanSynchronisation");
require("../StandardProtections/ServerBanSynchronisation");
test('That the migration handler is applied appropriatley when disabling protections', async function () {
    const protections = [
        'MemberBanSynchronisationProtection',
        'ServerBanSynchronisationProtection',
    ];
    // We need to have the account data fake figured out first
    // Then we need to construct the migration handler with test data
    // Then we need to construct the StandardProtectionsConfig with the migration handler and check the migration was used
    // Then we need to disable some protections put in by the migration handler.
    // Then we need to construct a new migration handler from the same account data fake and test that everything is good.
    const fakeConfigBackend = new FakePersistentMatrixData_1.FakePersistentConfigBackend({});
    const testMigrationHandler = new SchemedMatrixData_1.SchemedDataManager([
        async (data, toVersion) => (0, typescript_result_1.Ok)({
            enabled: [...data.enabled, protections[0]],
            [SchemedMatrixData_1.DRAUPNIR_SCHEMA_VERSION_KEY]: toVersion,
        }),
        async (data, toVersion) => (0, typescript_result_1.Ok)({
            enabled: [...data.enabled, protections[1]],
            [SchemedMatrixData_1.DRAUPNIR_SCHEMA_VERSION_KEY]: toVersion,
        }),
    ]);
    const initialProtectionsConfig = (await StandardProtectionsConfig_1.MjolnirProtectionsConfig.create(fakeConfigBackend, new LoggableConfig_1.StandardLoggableConfigTracker(), { migrationHandler: testMigrationHandler })).expect('Should be able to create the enabled protections');
    expect(initialProtectionsConfig.getKnownEnabledProtections().length).toBe(2);
    (await initialProtectionsConfig.disableProtection(protections[1])).expect('Should be able to disable protections');
    const postDisableProtections = Value_1.Value.Decode(MjolnirEnabledProtectionsEvent_1.MjolnirEnabledProtectionsEvent, (await fakeConfigBackend.requestUnparsedConfig()).expect('Should be able to get the fake account data')).expect('Should be able to decode the fake account data');
    expect(postDisableProtections.enabled.length).toBe(1);
    expect(postDisableProtections[SchemedMatrixData_1.DRAUPNIR_SCHEMA_VERSION_KEY]).toBe(2);
});
//# sourceMappingURL=StandardProtectionsConfig.test.js.map