import { StringRoomID, MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { RoomStateRevision, RoomStateRevisionIssuer, StateChange } from './StateRevisionIssuer';
export type SetRoomStateListener = (roomID: StringRoomID, nextRevision: RoomStateRevision, changes: StateChange[], previousRevision: RoomStateRevision) => void;
export declare const SetRoomStateMirrorCord: Readonly<{
    readonly addRoom: unique symbol;
    readonly removeRoom: unique symbol;
}>;
export declare interface SetRoomState {
    [SetRoomStateMirrorCord.addRoom](room: MatrixRoomID, roomStateRevisionIssuer: RoomStateRevisionIssuer): void;
    [SetRoomStateMirrorCord.removeRoom](room: MatrixRoomID): void;
    on(event: 'revision', listener: SetRoomStateListener): this;
    off(event: 'revision', listener: SetRoomStateListener): this;
    emit(event: 'revision', ...args: Parameters<SetRoomStateListener>): boolean;
    unregisterListeners(): void;
    allRooms: RoomStateRevision[];
    getRevision(room: StringRoomID): RoomStateRevision | undefined;
}
export declare const SetRoomStateMirror: Readonly<{
    addRoom(setRoomState: SetRoomState, room: MatrixRoomID, revisionIssuer: RoomStateRevisionIssuer): void;
    removeRoom(setRoomState: SetRoomState, room: MatrixRoomID): void;
}>;
//# sourceMappingURL=SetRoomState.d.ts.map