"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.isInvitationForUser = isInvitationForUser;
exports.isSenderJoinedInRevision = isSenderJoinedInRevision;
const matrix_protection_suite_1 = require("matrix-protection-suite");
function isInvitationForUser(event, clientUserID) {
    return (event.state_key === clientUserID &&
        event.content.membership === matrix_protection_suite_1.Membership.Invite);
}
function isSenderJoinedInRevision(senderUserID, membership) {
    const senderMembership = membership.membershipForUser(senderUserID);
    return Boolean(senderMembership?.content.membership === matrix_protection_suite_1.Membership.Join);
}
//# sourceMappingURL=inviteCore.js.map