"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDraupnirStores = createDraupnirStores;
exports.makeTopLevelStores = makeTopLevelStores;
const SqliteRoomStateBackingStore_1 = require("./better-sqlite3/SqliteRoomStateBackingStore");
const HashStore_1 = require("./better-sqlite3/HashStore");
const SqliteRoomAuditLog_1 = require("../protections/RoomTakedown/SqliteRoomAuditLog");
const SqliteUserRestrictionAuditLog_1 = require("../protections/HomeserverUserPolicyApplication/SqliteUserRestrictionAuditLog");
function createDraupnirStores(topLevelStores) {
    return Object.freeze({
        roomAuditLog: topLevelStores.roomAuditLog,
        hashStore: topLevelStores.hashStore,
        userRestrictionAuditLog: topLevelStores.userRestrictionAuditLog,
        dispose() { },
    });
}
function makeTopLevelStores(storagePath, eventDecoder, { isRoomStateBackingStoreEnabled, }) {
    return Object.freeze({
        roomStateBackingStore: isRoomStateBackingStoreEnabled
            ? SqliteRoomStateBackingStore_1.SqliteRoomStateBackingStore.create(storagePath, eventDecoder)
            : undefined,
        hashStore: HashStore_1.SqliteHashReversalStore.createToplevel(storagePath),
        roomAuditLog: SqliteRoomAuditLog_1.SqliteRoomAuditLog.createToplevel(storagePath),
        userRestrictionAuditLog: SqliteUserRestrictionAuditLog_1.SqliteUserRestrictionAuditLog.createToplevel(storagePath),
        dispose() {
            this.roomStateBackingStore?.destroy();
            this.hashStore?.destroy();
            this.roomAuditLog?.destroy();
            this.userRestrictionAuditLog?.destroy();
        },
    });
}
//# sourceMappingURL=DraupnirStores.js.map