"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from Draupnir
// https://github.com/the-draupnir-project/Draupnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeDraupnirCommandNormaliser = makeDraupnirCommandNormaliser;
exports.makeDraupnirCommandDispatcher = makeDraupnirCommandDispatcher;
exports.makeDraupnirJSCommandDispatcher = makeDraupnirJSCommandDispatcher;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const Help_1 = require("./Help");
const DraupnirCommandTable_1 = require("./DraupnirCommandTable");
const DraupnirCommandPrerequisites_1 = require("./DraupnirCommandPrerequisites");
require("./DraupnirCommands");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
function makeDraupnirCommandNormaliser(clientUserID, displayNameIssuer, config) {
    return (0, interface_manager_1.makeCommandNormaliser)(clientUserID, {
        symbolPrefixes: config.commands.symbolPrefixes,
        isAllowedOnlySymbolPrefixes: config.commands.allowNoPrefix,
        additionalPrefixes: ["draupnir", ...config.commands.additionalPrefixes],
        getDisplayName: function () {
            return displayNameIssuer.clientDisplayName;
        },
        normalisedPrefix: "draupnir",
    });
}
function makeDraupnirCommandDispatcher(draupnir) {
    return new interface_manager_1.StandardMatrixInterfaceCommandDispatcher(DraupnirCommandPrerequisites_1.DraupnirInterfaceAdaptor, draupnir, DraupnirCommandTable_1.DraupnirTopLevelCommands, Help_1.DraupnirHelpCommand, mps_interface_adaptor_1.invocationInformationFromMatrixEventcontext, {
        ...mps_interface_adaptor_1.MPSCommandDispatcherCallbacks,
        commandNormaliser: makeDraupnirCommandNormaliser(draupnir.clientUserID, draupnir, draupnir.config),
    });
}
function makeDraupnirJSCommandDispatcher(draupnir) {
    return new interface_manager_1.StandardJSInterfaceCommandDispatcher(DraupnirCommandTable_1.DraupnirTopLevelCommands, Help_1.DraupnirHelpCommand, draupnir, {
        ...mps_interface_adaptor_1.MPSCommandDispatcherCallbacks,
        commandNormaliser: makeDraupnirCommandNormaliser(draupnir.clientUserID, draupnir, draupnir.config),
    }, DraupnirCommandPrerequisites_1.DraupnirContextToCommandContextTranslator);
}
//# sourceMappingURL=DraupnirCommandDispatcher.js.map