"use strict";
// Copyright 2023 Marcel <MTRNord@users.noreply.github.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.DraupnirDisplaynameCommand = void 0;
const typescript_result_1 = require("@gnuxie/typescript-result");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const DraupnirCommandPrerequisites_1 = require("./DraupnirCommandPrerequisites");
exports.DraupnirDisplaynameCommand = (0, interface_manager_1.describeCommand)({
    summary: "Sets the displayname of the draupnir instance to the specified value in all rooms.",
    parameters: [],
    rest: {
        name: "displayname",
        acceptor: interface_manager_1.StringPresentationType,
    },
    async executor(draupnir, _info, _keywords, displaynameParts) {
        const displayname = displaynameParts.join(" ");
        try {
            await draupnir.client.setDisplayName(displayname);
        }
        catch (e) {
            const message = e.message || (e.body ? e.body.error : "<no message>");
            return matrix_protection_suite_1.ActionError.Result(`Failed to set displayname to ${displayname}: ${message}`);
        }
        return (0, typescript_result_1.Ok)(undefined);
    },
});
DraupnirCommandPrerequisites_1.DraupnirInterfaceAdaptor.describeRenderer(exports.DraupnirDisplaynameCommand, {
    isAlwaysSupposedToUseDefaultRenderer: true,
});
//# sourceMappingURL=SetDisplayNameCommand.js.map