"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateWatchPreview = generateWatchPreview;
exports.renderMemberBanIntents = renderMemberBanIntents;
exports.renderServerBanIntents = renderServerBanIntents;
exports.renderWatchPreview = renderWatchPreview;
exports.renderWatchCommandPreview = renderWatchCommandPreview;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
const matrix_protection_suite_1 = require("matrix-protection-suite");
function watchDeltaForMemberBanIntents(setMembershipPoliciesRevision, setMembershipRevision, watchedPoliciesDelta, memberBanIntentProjectionNode) {
    const setMembershipPoliciesRevisionDelta = setMembershipPoliciesRevision.changesFromPolicyChanges(watchedPoliciesDelta, setMembershipRevision);
    return memberBanIntentProjectionNode.reduceInput(setMembershipPoliciesRevisionDelta);
}
function watchDeltaForServerBanIntents(watchedPoliciesDelta, serverBanIntentProjectionNode) {
    return serverBanIntentProjectionNode.reduceInput(watchedPoliciesDelta);
}
function generateWatchPreview(protectedRoomsSet, nextPolicyRoom) {
    const previewPoliciesRevisionChanges = nextPolicyRoom
        .allRules()
        .map((rule) => ({
        changeType: matrix_protection_suite_1.PolicyRuleChangeType.Added,
        rule,
        event: rule.sourceEvent,
        sender: rule.sourceEvent.sender,
    }));
    const currentMemberBanIntentProjectionNode = protectedRoomsSet.protections.findEnabledProtection(matrix_protection_suite_1.MemberBanSynchronisationProtection.name)?.intentProjection.currentNode;
    const currentServerBanIntentProjectionNode = protectedRoomsSet.protections.findEnabledProtection(matrix_protection_suite_1.ServerBanSynchronisationProtection.name)?.intentProjection.currentNode;
    return {
        memberBanIntentProjectionDelta: currentMemberBanIntentProjectionNode
            ? watchDeltaForMemberBanIntents(protectedRoomsSet.setPoliciesMatchingMembership.currentRevision, protectedRoomsSet.setMembership.currentRevision, previewPoliciesRevisionChanges, currentMemberBanIntentProjectionNode)
            : undefined,
        serverBanIntentProjectionDelta: currentServerBanIntentProjectionNode
            ? watchDeltaForServerBanIntents(previewPoliciesRevisionChanges, currentServerBanIntentProjectionNode)
            : undefined,
        revision: nextPolicyRoom,
    };
}
function renderMemberBanIntents(delta) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("details", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("summary", null,
            "Draupnir intends to ban ",
            delta.ban.length,
            " users"),
        interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null, delta.ban.map((userID) => (interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
            (0, mps_interface_adaptor_1.renderMentionPill)(userID, userID),
            " (",
            interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, userID),
            ")"))))));
}
function renderServerBanIntents(delta) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("details", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("summary", null,
            "Draupnir intends to deny ",
            delta.deny.length,
            " servers"),
        interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null, delta.deny.map((serverName) => (interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
            interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, serverName)))))));
}
function renderWatchPreview(preview) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("h4", null,
            "Policy Room Subscription Preview for",
            " ",
            (0, mps_interface_adaptor_1.renderRoomPill)(preview.revision.room)),
        preview.memberBanIntentProjectionDelta ? (renderMemberBanIntents(preview.memberBanIntentProjectionDelta)) : (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null)),
        preview.serverBanIntentProjectionDelta ? (renderServerBanIntents(preview.serverBanIntentProjectionDelta)) : (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null))));
}
function renderWatchCommandPreview(preview) {
    return interface_manager_1.DeadDocumentJSX.JSXFactory("root", null, renderWatchPreview(preview));
}
//# sourceMappingURL=WatchPreview.js.map