export interface SuperCoolStream<Item, Sequence> {
    readonly source: Sequence;
    peekItem<EOF = undefined>(eof?: EOF): Item | EOF;
    readItem<EOF = undefined>(eof?: EOF): Item | EOF;
    getPosition(): number;
    setPosition(n: number): void;
    clone(): SuperCoolStream<Item, Sequence>;
    savingPositionIf<Result>(description: {
        predicate: (t: Result) => boolean;
        body: (stream: SuperCoolStream<Item, Sequence>) => Result;
    }): Result;
}
interface Indexable<Item> {
    at(position: number): Item | undefined;
}
export declare class StandardSuperCoolStream<Item, Sequence extends Indexable<Item>> implements SuperCoolStream<Item, Sequence> {
    readonly source: Sequence;
    protected position: number;
    /**
     * Makes the super cool string stream.
     * @param source A string to act as the source of the stream.
     * @param start Where in the string we should start reading.
     */
    constructor(source: Sequence, start?: number);
    peekItem<EOF = undefined>(eof?: EOF): Item | EOF;
    readItem<EOF = undefined>(eof?: EOF): EOF | NonNullable<Item>;
    getPosition(): number;
    setPosition(n: number): void;
    clone(): SuperCoolStream<Item, Sequence>;
    savingPositionIf<Result>(description: {
        predicate: (t: Result) => boolean;
        body: (stream: SuperCoolStream<Item, Sequence>) => Result;
    }): Result;
}
/**
 * Helper for peeking and reading character by character.
 */
export declare class StringStream extends StandardSuperCoolStream<string, Indexable<string>> {
    peekChar<EOF = undefined>(eof?: EOF): string | EOF;
    readChar<EOF = undefined>(eof?: EOF): string | EOF;
    clone(): StringStream;
}
/**
 * Tracks columns and rows. Can't handle any other line ending than line feed atm.
 */
export declare class RowTrackingStringStream extends StringStream {
    private row;
    private column;
    constructor(source: string, position: number, row?: number, column?: number);
    readItem<EOF = undefined>(eof?: EOF): string | EOF;
    clone(): RowTrackingStringStream;
    get peekRow(): number;
    get peekColumn(): number;
    get readRow(): number;
    get readColumn(): number;
}
export {};
//# sourceMappingURL=SuperCoolStream.d.ts.map