"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeCommandNormaliser = makeCommandNormaliser;
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const super_cool_stream_1 = require("@gnuxie/super-cool-stream");
function readUntil(regex, stream) {
    let output = "";
    while (stream.peekChar() !== undefined && !regex.test(stream.peekChar())) {
        output += stream.readChar();
    }
    return output.length === 0 ? undefined : output;
}
function maybeReadPrefixes(body, plainPrefixes, { symbolPrefixes, isAllowedOnlySymbolPrefixes, normalisedPrefix, }) {
    const stream = new super_cool_stream_1.StringStream(body);
    readUntil(/\S/, stream);
    const firstWord = readUntil(/\s/, stream);
    if (firstWord === undefined || typeof firstWord !== "string") {
        return undefined;
    }
    const usedSymbolPrefix = symbolPrefixes.find((p) => firstWord.toLowerCase().startsWith(p));
    const additionalPrefixTarget = usedSymbolPrefix
        ? firstWord.slice(usedSymbolPrefix.length)
        : firstWord;
    const usedAdditionalPrefix = plainPrefixes.find((p) => additionalPrefixTarget.toLowerCase() === p);
    if (usedAdditionalPrefix && usedSymbolPrefix) {
        return (normalisedPrefix + stream.source.slice(stream.getPosition()));
    }
    if (usedSymbolPrefix && isAllowedOnlySymbolPrefixes) {
        return (normalisedPrefix +
            " " +
            additionalPrefixTarget +
            stream.source.slice(stream.getPosition()));
    }
    return undefined;
}
function maybeExtractDisplayNameMention(body, displayNameWords, options) {
    const stream = new super_cool_stream_1.StringStream(body);
    for (const name of displayNameWords) {
        readUntil(/\S/, stream);
        const word = readUntil(/\s/, stream);
        if (word === undefined) {
            return undefined;
        }
        // check for : on the end of pills.
        if (word.endsWith(":")) {
            if (word.slice(0, word.length - 1) !== name) {
                return undefined;
            }
        }
        else if (word !== name) {
            return undefined;
        }
    }
    readUntil(/\S/, stream);
    if (stream.peekChar() === ":") {
        stream.readChar();
    }
    return (options.normalisedPrefix +
        " " +
        stream.source.slice(stream.getPosition()));
}
function maybeExtractMarkdownMention(body, clientUserID, normalisedPrefix) {
    const result = /^\[([^\]]+)\]\([^)]+\)\s*:?\s*/.exec(body);
    if (result === null) {
        return undefined;
    }
    if (result[1] === clientUserID) {
        return normalisedPrefix + " " + body.slice(result[0].length);
    }
    else {
        return undefined;
    }
}
function makeCommandNormaliser(clientUserID, options) {
    const { additionalPrefixes, getDisplayName, normalisedPrefix } = options;
    const plainPrefixes = [
        (0, matrix_basic_types_1.userLocalpart)(clientUserID),
        clientUserID,
        ...additionalPrefixes,
    ];
    // Remember to check for shit like :
    // These are the ways that a prefix can be used:
    // 1. By a displayname or a mention pill
    // 2. By an additional prefix like the draupnir in !draupnir
    // 3. By use of just a symbol prefix like ! and nothing else.
    return (body) => {
        const prefixResult = maybeReadPrefixes(body, plainPrefixes, options);
        if (prefixResult !== undefined) {
            return prefixResult;
        }
        // now we just need to match against displaynames and other pills
        const displayNameWords = getDisplayName().split(/\s+/).filter(Boolean);
        const displayNameResult = maybeExtractDisplayNameMention(body, displayNameWords, options);
        if (displayNameResult !== undefined) {
            return displayNameResult;
        }
        return maybeExtractMarkdownMention(body, clientUserID, normalisedPrefix);
    };
}
//# sourceMappingURL=CommandDispatcher.js.map