import { Result } from "@gnuxie/typescript-result";
import { CommandMeta, CompleteCommand, PartialCommand } from "../Command";
export interface CommandInvoker<CommandInformation> {
    /**
     * Invoke the command object, running the command executor.
     */
    invoke<TCommandMeta extends CommandMeta>(commandContext: TCommandMeta["Context"], commandInformation: CommandInformation, command: CompleteCommand<TCommandMeta>): Promise<Result<TCommandMeta["CommandResult"]>>;
    parseCommand(commandInformation: CommandInformation, partialCommand: PartialCommand): Result<CompleteCommand>;
}
//# sourceMappingURL=CommandInvoker.d.ts.map