import { CommandDescription } from "./CommandDescription";
import { PresentationType, PresentationTypeWithoutWrap } from "./Presentation";
import { PresentationArgumentStream } from "./PresentationStream";
import { PresentationTypeTranslator } from "./PresentationTypeTranslator";
export type BaseCommandTableEntry = EmptyCommandTableEntry | CommandTableEntry | SubCommandTableEntry;
export type EmptyCommandTableEntry = {
    designator: string[];
    sourceTable: CommandTable;
    subCommands?: never;
    currentCommand?: never;
};
export type CommandTableEntry = {
    subCommands?: Map<string, BaseCommandTableEntry>;
    currentCommand: CommandDescription;
    designator: string[];
    sourceTable: CommandTable;
};
export type SubCommandTableEntry = {
    subCommands: Map<string, BaseCommandTableEntry>;
    currentCommand?: CommandDescription;
    designator: string[];
    sourceTable: CommandTable;
};
export type CommandTableImport = {
    table: CommandTable;
    baseDesignator: string[];
};
export interface CommandTable {
    readonly name: string | symbol;
    /**
     * Can be used to render a help command with an index of all the commands.
     * @returns All of the commands in this table.
     */
    getAllCommands(): CommandTableEntry[];
    /**
     * @returns Only the commands interned in this table, excludes imported commands.
     */
    getExportedCommands(): CommandTableEntry[];
    getImportedTables(): CommandTableImport[];
    findAMatchingCommand(stream: PresentationArgumentStream): CommandDescription | undefined;
    internCommand(command: CommandDescription, designator: string[]): CommandTable;
    /**
     * Import the commands from a different table into this one.
     * @param baseDesignator A designator to use as a base for all of the table's
     * commands before importing them. So for example, commands for the join wave
     * short-circuit protection might add a base designator of ["join" "wave"].
     * So the complete designator for a status command that the join wave short-circuit
     * protection defined would be  ["join", "wave", "status"] in this table.
     */
    importTable(table: CommandTable, baseDesignator: string[]): void;
    isContainingCommand(command: CommandDescription): boolean;
    internPresentationTypeTranslator(translator: PresentationTypeTranslator): CommandTable;
    findPresentationTypeTranslator(toType: PresentationTypeWithoutWrap, fromType: PresentationTypeWithoutWrap): PresentationTypeTranslator | undefined;
}
export declare class StandardCommandTable implements CommandTable {
    readonly name: string | symbol;
    private readonly exportedCommands;
    private readonly flattenedCommands;
    private readonly commands;
    private readonly translators;
    /** Imported tables are tables that "add commands" to this table. They are not sub commands. */
    private readonly importedTables;
    constructor(name: string | symbol);
    /**
     * Can be used to render a help command with an index of all the commands.
     * @returns All of the commands in this table.
     */
    getAllCommands(): CommandTableEntry[];
    /**
     * @returns Only the commands interned in this table, excludes imported commands.
     */
    getExportedCommands(): CommandTableEntry[];
    getImportedTables(): CommandTableImport[];
    private findAMatchingCommandEntry;
    findAMatchingCommand(stream: PresentationArgumentStream): CommandDescription | undefined;
    private internCommandHelper;
    internCommand(command: CommandDescription, designator: string[]): this;
    importTable(importedTable: CommandTable, baseDesignator: string[]): void;
    isContainingCommand(command: CommandDescription): boolean;
    private keyFromTranslator;
    internPresentationTypeTranslator(translator: PresentationTypeTranslator): CommandTable;
    findPresentationTypeTranslator(toType: PresentationType, fromType: PresentationType): PresentationTypeTranslator | undefined;
}
//# sourceMappingURL=CommandTable.d.ts.map