import { Result, ResultError } from "@gnuxie/typescript-result";
import { ParameterDescription } from "./ParameterDescription";
import { PartialCommand } from "./Command";
export declare class AbstractArgumentParseError extends ResultError {
    readonly partialCommand: PartialCommand;
    constructor(partialCommand: PartialCommand, message: string);
    static Result(message: string, options: {
        partialCommand: PartialCommand;
    }): Result<never, AbstractArgumentParseError>;
}
export declare class ArgumentParseError extends AbstractArgumentParseError {
    readonly parameter: ParameterDescription;
    constructor(parameter: ParameterDescription, partialCommand: PartialCommand, message: string);
    static Result(message: string, options: {
        parameter: ParameterDescription;
        partialCommand: PartialCommand;
    }): Result<never, ArgumentParseError>;
}
export declare class UnexpectedArgumentError extends AbstractArgumentParseError {
    static Result<Ok>(message: string, options: {
        partialCommand: PartialCommand;
    }): Result<Ok, UnexpectedArgumentError>;
}
export interface PromptContext {
    items: string[];
    designator: string[];
}
export declare class PromptRequiredError extends ResultError {
    readonly parameterRequiringPrompt: ParameterDescription;
    readonly partialCommand: PartialCommand;
    constructor(message: string, context: string[], parameterRequiringPrompt: ParameterDescription, partialCommand: PartialCommand);
    static Result(message: string, { promptParameter, partialCommand, }: {
        promptParameter: ParameterDescription;
        partialCommand: PartialCommand;
    }): Result<never, PromptRequiredError>;
}
//# sourceMappingURL=ParseErrors.d.ts.map