import { ObjectTypeFromPresentationType, Presentation, PresentationTypeWithoutWrap } from "./Presentation";
import { CommandTable } from "./CommandTable";
export declare enum PresentationSchemaType {
    Single = "Single",
    Union = "Union",
    Top = "Top"
}
type ObjectTypeForSingleSchema<T extends SinglePresentationSchema> = T["presentationType"] extends PresentationTypeWithoutWrap<infer ObjectType> ? ObjectType : never;
type ObjectTypeForUnionSchema<T extends UnionPresentationSchema> = T["variants"] extends PresentationTypeWithoutWrap<infer ObjectType>[] ? ObjectType : never;
type ObjectTypeForTopSchema = unknown;
/**
 * There is something wrong with the way argument parsing code is using validators
 * of presnetation types. When a parameter has declared that it expects arguments
 * to be of a presnetation type, all we should be doing is checking that the
 * presentationType of the argument is the specified presentation type.
 *
 * This works, except what happens when we want a command that accepts a union
 * of presentation types, or maybe the union of all known presentation types?
 *
 * Well that is probably an issue for the parameter description code right?
 * It has to specify a schema for the argument to get the presentation types it
 * expects, rather than just a presentation type.
 *
 * So is born the presentation schema.
 */
export type SinglePresentationSchema<ObjectType = unknown> = {
    readonly schemaType: PresentationSchemaType.Single;
    readonly presentationType: PresentationTypeWithoutWrap<ObjectType>;
};
export type UnionPresentationSchema<ObjectType = unknown> = {
    readonly schemaType: PresentationSchemaType.Union;
    readonly variants: PresentationTypeWithoutWrap<ObjectType>[];
};
export type TopPresentationSchema = {
    readonly schemaType: PresentationSchemaType.Top;
};
export declare const TopPresentationSchema: TopPresentationSchema;
export type PresentationSchema<ObjectType = unknown> = SinglePresentationSchema<ObjectType> | UnionPresentationSchema<ObjectType> | TopPresentationSchema;
export type ObjectTypeForPresentationSchema<T> = T extends SinglePresentationSchema ? ObjectTypeForSingleSchema<T> : T extends UnionPresentationSchema ? ObjectTypeForUnionSchema<T> : T extends TopPresentationSchema ? ObjectTypeForTopSchema : never;
export declare function checkPresentationSchema<ObjectType>(schema: PresentationSchema, presentation: Presentation): presentation is Presentation<ObjectType>;
export declare function acceptPresentation<ObjectType>(schema: PresentationSchema<ObjectType>, commandTable: CommandTable, presentation: Presentation): Presentation<ObjectType> | undefined;
export declare function printPresentationSchema(schema: PresentationSchema): string;
type Acceptor<ObjectType = unknown> = PresentationSchema<ObjectType> | PresentationTypeWithoutWrap<ObjectType>;
export type ObjectTypeFromAcceptor<T> = T extends PresentationTypeWithoutWrap ? ObjectTypeFromPresentationType<T> : T extends PresentationSchema ? ObjectTypeForPresentationSchema<T> : never;
type UnionOfObjectTypes<T extends Acceptor[]> = {
    [P in keyof T]: T[P] extends Acceptor<infer U> ? U : never;
}[number];
export declare function union<TAcceptor extends (PresentationTypeWithoutWrap | UnionPresentationSchema)[]>(...acceptors: TAcceptor): UnionPresentationSchema<UnionOfObjectTypes<TAcceptor>>;
export {};
//# sourceMappingURL=PresentationSchema.d.ts.map