"use strict";
// Copyright 2023 - 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.PromptableArgumentStream = void 0;
const PresentationStream_1 = require("./PresentationStream");
class PromptableArgumentStream extends PresentationStream_1.StandardPresentationArgumentStream {
    constructor(source, interfaceAcceptor, start = 0) {
        super([...source], start);
        this.interfaceAcceptor = interfaceAcceptor;
    }
    rest() {
        return this.source.slice(this.position);
    }
    isPromptable() {
        return this.interfaceAcceptor.isPromptable;
    }
}
exports.PromptableArgumentStream = PromptableArgumentStream;
//# sourceMappingURL=PromptForAccept.js.map