import { DocumentNode, LeafNode, NodeTag } from "./DeadDocument";
type JSXChild = DocumentNode | LeafNode | string | number | JSXChild[];
type NodeProperties = {
    children?: JSXChild[] | JSXChild;
};
type LeafNodeProperties = {
    children?: never[];
};
export declare namespace DeadDocumentJSX {
    function JSXFactory(tag: NodeTag, properties?: Record<string, string>, ...rawChildren: (DocumentNode | LeafNode | string)[]): DocumentNode;
    namespace JSX {
        interface IntrinsicElements {
            a: NodeProperties & {
                href?: string;
                name?: string;
                target?: string;
            };
            b: NodeProperties;
            br: LeafNodeProperties;
            code: NodeProperties & {
                class?: string;
            };
            details: NodeProperties;
            em: NodeProperties;
            font: NodeProperties & {
                color?: string;
            };
            fragment: NodeProperties;
            h1: NodeProperties;
            h2: NodeProperties;
            h3: NodeProperties;
            h4: NodeProperties;
            h5: NodeProperties;
            h6: NodeProperties;
            hr: LeafNodeProperties;
            i: NodeProperties;
            li: NodeProperties;
            ol: NodeProperties & {
                start?: number;
            };
            p: NodeProperties;
            pre: NodeProperties;
            root: NodeProperties;
            span: NodeProperties & {
                "data-mx-bg-color"?: string;
                "data-mx-color"?: string;
                "data-mx-spoiler"?: string | undefined;
            };
            strong: NodeProperties;
            summary: NodeProperties;
            ul: NodeProperties;
        }
        type Element = DocumentNode;
        type ElementChildrenAttribute = {
            children?: JSXChild[] | JSXChild | never[];
        };
    }
}
export {};
//# sourceMappingURL=JSXFactory.d.ts.map