import { CommandDescription, CommandTable } from "../Command";
import { PresentationArgumentStream } from "../Command/PresentationStream";
import { BasicInvocationInformation } from "../MatrixInterfaceAdaptor";
import { AdaptorContextToCommandContextTranslator, CommandDispatcherCallbacks } from "../Adaptor";
import { Result } from "@gnuxie/typescript-result";
export declare class StandardJSInterfaceCommandDispatcher<AdaptorContext> implements JSInterfaceCommandDispatcher<BasicInvocationInformation> {
    private readonly commandTable;
    private readonly helpCommand;
    private readonly adaptorContext;
    private readonly callbacks;
    private readonly contextTranslator?;
    private readonly commandInvoker;
    private readonly commandDispatcher;
    constructor(commandTable: CommandTable, helpCommand: CommandDescription, adaptorContext: AdaptorContext, callbacks: CommandDispatcherCallbacks<BasicInvocationInformation>, contextTranslator?: AdaptorContextToCommandContextTranslator<AdaptorContext> | undefined);
    private invokeAndParsePartialCommand;
    invokeCommandFromPresentationStream<CommandResult>(invocationInformation: BasicInvocationInformation, stream: PresentationArgumentStream): Promise<Result<CommandResult>>;
    invokeCommandFromBody<CommandResult>(invocationInformation: BasicInvocationInformation, body: string): Promise<Result<CommandResult>>;
}
export interface JSInterfaceCommandDispatcher<InvocationInformation> {
    invokeCommandFromBody<CommandResult>(invocationInformation: InvocationInformation, body: string): Promise<Result<CommandResult>>;
    invokeCommandFromPresentationStream<CommandResult>(invocationInformation: InvocationInformation, stream: PresentationArgumentStream): Promise<Result<CommandResult>>;
}
//# sourceMappingURL=JSInterfaceCommandDispatcher.d.ts.map