"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringFromMatrixEventReferenceTranslator = exports.StringFromMatrixUserIDTranslator = exports.StringFromMatrixRoomAliasTranslator = exports.StringFromMatrixRoomIDTranslator = exports.StringfromBooleanTranslator = exports.StringFromNumberTranslator = void 0;
const PresentationTypeTranslator_1 = require("../Command/PresentationTypeTranslator");
const TextPresentationRenderer_1 = require("./TextPresentationRenderer");
const TextPresentationTypes_1 = require("./TextPresentationTypes");
exports.StringFromNumberTranslator = (0, PresentationTypeTranslator_1.describeTranslator)(TextPresentationTypes_1.StringPresentationType, TextPresentationTypes_1.NumberPresentationType, function (from) {
    return TextPresentationTypes_1.StringPresentationType.wrap(from.object.toString());
});
exports.StringfromBooleanTranslator = (0, PresentationTypeTranslator_1.describeTranslator)(TextPresentationTypes_1.StringPresentationType, TextPresentationTypes_1.BooleanPresentationType, function (from) {
    return TextPresentationTypes_1.StringPresentationType.wrap(TextPresentationRenderer_1.TextPresentationRenderer.render(from));
});
exports.StringFromMatrixRoomIDTranslator = (0, PresentationTypeTranslator_1.describeTranslator)(TextPresentationTypes_1.StringPresentationType, TextPresentationTypes_1.MatrixRoomIDPresentationType, function (from) {
    return TextPresentationTypes_1.StringPresentationType.wrap(from.object.toString());
});
exports.StringFromMatrixRoomAliasTranslator = (0, PresentationTypeTranslator_1.describeTranslator)(TextPresentationTypes_1.StringPresentationType, TextPresentationTypes_1.MatrixRoomAliasPresentationType, function (from) {
    return TextPresentationTypes_1.StringPresentationType.wrap(from.object.toString());
});
exports.StringFromMatrixUserIDTranslator = (0, PresentationTypeTranslator_1.describeTranslator)(TextPresentationTypes_1.StringPresentationType, TextPresentationTypes_1.MatrixUserIDPresentationType, function (from) {
    return TextPresentationTypes_1.StringPresentationType.wrap(from.object.toString());
});
exports.StringFromMatrixEventReferenceTranslator = (0, PresentationTypeTranslator_1.describeTranslator)(TextPresentationTypes_1.StringPresentationType, TextPresentationTypes_1.MatrixEventReferencePresentationType, function (from) {
    return TextPresentationTypes_1.StringPresentationType.wrap(`${from.object.reference.toPermalink()}/${from.object.eventID}`);
});
//# sourceMappingURL=TextTranslators.js.map